# Visual Sync Architecture & Data Flow

## Where Settings Live

```
LOCAL DEVELOPMENT SETUP
═══════════════════════════════════════════════════════════════

BROWSER
   ↓
PHP/Laravel Application
   ↓
┌─────────────────────────────────────┐
│         DISPLAYS ON PAGE             │
├─────────────────────────────────────┤
│ • Company Logo                       │
│ • Company Name                       │
│ • Theme Colors                       │
│ • Banners                            │
│ • Products                           │
│ • Links to Images                    │
└────────────────┬────────────────────┘
                 │ reads from
                 ↓
     ┌───────────────────────────┐
     │    DATABASE (MySQL)        │
     ├───────────────────────────┤
     │ business_settings table:   │
     │ • company_name             │
     │ • company_web_logo         │
     │ • primary_color            │
     │ • secondary_color          │
     │ • company_email            │
     │ • ... 50+ other settings   │
     │                            │
     │ banners table:             │
     │ • banner images paths      │
     │ • positions/types          │
     │                            │
     │ categories table:          │
     │ • category names           │
     │ • category icons paths     │
     │                            │
     │ products table:            │
     │ • product names            │
     │ • image paths              │
     └───────────────┬────────────┘
                     │
          ┌──────────┴──────────┐
          ↓                     ↓
    ┌──────────────┐    ┌──────────────┐
    │ Links to →   │    │ Links to →   │
    │ Image Files  │    │ Image Files  │
    └──────┬───────┘    └──────┬───────┘
           │                   │
           ↓                   ↓
    ┌─────────────────────────────────────┐
    │   public/storage/ (File System)      │
    ├─────────────────────────────────────┤
    │ ├── company/                         │
    │ │   ├── logo.png                     │
    │ │   ├── favicon.ico                  │
    │ │   └── footer-logo.png              │
    │ ├── banner/                          │
    │ │   ├── banner-1.jpg                 │
    │ │   ├── banner-2.jpg                 │
    │ │   └── ...                          │
    │ ├── product/                         │
    │ │   ├── thumbnail/                   │
    │ │   │   ├── product-1.jpg            │
    │ │   │   └── ...                      │
    │ │   └── ...                          │
    │ └── category/, brand/, shop/ ...     │
    └─────────────────────────────────────┘
```

---

## Two-Part Sync Required

```
LOCAL STATE                          LIVE STATE
═════════════════════════════════════════════════════════════════

BEFORE SYNC:
┌─────────────────────────┐         ┌──────────────────────────┐
│ Database (multivendor)  │         │ Database (live_db)       │
├─────────────────────────┤         ├──────────────────────────┤
│ ✓ business_settings     │         │ ✗ Empty tables           │
│ ✓ banners               │         │ ✗ No config              │
│ ✓ brands                │         │ ✗ No banners             │
│ ✓ categories            │         │                          │
│ ✓ All your config data  │         │                          │
└──────────┬──────────────┘         └──────────────────────────┘
           │                                   ↑
           │ EXPORT with mysqldump            │ IMPORT here
           └───────────────────────────────────┘

┌─────────────────────────┐         ┌──────────────────────────┐
│ public/storage/         │         │ public/storage/          │
├─────────────────────────┤         ├──────────────────────────┤
│ ✓ company/              │         │ ✗ Empty                  │
│ ✓ banner/               │         │ ✗ No images              │
│ ✓ product/              │         │ ✗ No files               │
│ ✓ brand/                │         │                          │
│ ✓ shop/                 │         │                          │
│ ✓ category/             │         │                          │
└──────────┬──────────────┘         └──────────────────────────┘
           │                                   ↑
           │ COPY with tar/SCP               │ EXTRACT here
           └───────────────────────────────────┘

AFTER SYNC:
┌─────────────────────────┐         ┌──────────────────────────┐
│ Database (multivendor)  │         │ Database (live_db)       │
├─────────────────────────┤         ├──────────────────────────┤
│ ✓ business_settings ←───┼─────────→ ✓ business_settings      │
│ ✓ banners           ←───┼─────────→ ✓ banners                │
│ ✓ brands            ←───┼─────────→ ✓ brands                 │
│ ✓ categories        ←───┼─────────→ ✓ categories             │
└──────────┬──────────────┘         └──────────┬───────────────┘
           │                                   │
           ↓                                   ↓
┌─────────────────────────┐         ┌──────────────────────────┐
│ public/storage/         │         │ public/storage/          │
├─────────────────────────┤         ├──────────────────────────┤
│ ✓ company/          ←───┼─────────→ ✓ company/               │
│ ✓ banner/           ←───┼─────────→ ✓ banner/                │
│ ✓ product/          ←───┼─────────→ ✓ product/               │
│ ✓ brand/            ←───┼─────────→ ✓ brand/                 │
│ ✓ shop/             ←───┼─────────→ ✓ shop/                  │
│ ✓ category/         ←───┼─────────→ ✓ category/              │
└─────────────────────────┘         └──────────────────────────┘

RESULT:
┌─────────────────────────────────────────────────────────────┐
│ LIVE SERVER NOW LOOKS IDENTICAL TO LOCAL                    │
│ ✓ Same logo and branding                                    │
│ ✓ Same colors and styling                                   │
│ ✓ Same banners and content                                  │
│ ✓ Same product images                                       │
└─────────────────────────────────────────────────────────────┘
```

---

## Database Flow Detailed

```
business_settings TABLE (The Config Hub)
═══════════════════════════════════════════════════════════════

┌─────────────────────────────────────────────────────────────┐
│ id │ key                      │ value                        │
├────┼──────────────────────────┼──────────────────────────────┤
│ 1  │ company_name             │ "E-Africa Mall"              │
│ 2  │ company_email            │ "info@eafricamall.com"       │
│ 3  │ company_phone            │ "+234 700 123 4567"          │
│ 4  │ company_web_logo         │ "/path/to/logo.png"          │
│ 5  │ company_fav_icon         │ "/path/to/favicon.ico"       │
│ 6  │ company_footer_logo      │ "/path/to/footer-logo.png"   │
│ 7  │ primary_color            │ "#FF6B6B"                    │
│ 8  │ secondary_color          │ "#4ECDC4"                    │
│ 9  │ colors                   │ JSON with all colors         │
│ 10 │ currency_model           │ "1" (USD or local)           │
│ 11 │ about_us                 │ "Company description..."     │
│ 12 │ seller_registration      │ "1"                          │
│ 13 │ wallet_status            │ "1"                          │
│ 14 │ ... (50+ more settings)  │ ...                          │
└─────────────────────────────────────────────────────────────┘

        ↓ All these values are loaded by AppServiceProvider.php
        ↓ And made available as $web_config in ALL views

        ↓
     ┌──────────────────────────────────┐
     │ App displays:                     │
     ├──────────────────────────────────┤
     │ Logo: {{ $web_config['...'] }}   │
     │ Name: {{ $web_config['...'] }}   │
     │ Colors: CSS with theme colors    │
     │ Email: {{ $web_config['...'] }}  │
     └──────────────────────────────────┘
```

---

## File Storage Architecture

```
public/storage/ (File System Storage)
═══════════════════════════════════════════════════════════════

Folder Organization by Purpose:

┌─ company/                    ← COMPANY BRANDING
│   ├── logo_20250101.webp
│   ├── favicon.ico
│   └── footer_logo.webp
│
├─ banner/                     ← HOMEPAGE BANNERS
│   ├── main_banner_1.jpg
│   ├── section_banner_2.jpg
│   └── popup_banner.jpg
│
├─ brand/                      ← PRODUCT BRANDS
│   ├── brand_1_logo.webp
│   ├── brand_2_logo.webp
│   └── ...
│
├─ category/                   ← CATEGORY ICONS
│   ├── electronics_icon.webp
│   ├── clothing_icon.webp
│   └── ...
│
├─ product/                    ← PRODUCT IMAGES (Largest)
│   ├── thumbnail/
│   │   ├── product_1.jpg
│   │   ├── product_2.jpg
│   │   └── ...
│   ├── gallery/
│   │   └── product_1_detail.jpg
│   └── ...
│
├─ shop/                       ← VENDOR SHOP LOGOS
│   ├── vendor_1_logo.webp
│   ├── vendor_1_banner.jpg
│   └── ...
│
├─ seller/                     ← SELLER PROFILES
│   ├── seller_1_avatar.webp
│   └── ...
│
└─ profile/                    ← CUSTOMER PROFILES
    ├── customer_1_avatar.webp
    └── ...

Each folder is referenced by database records:
• banners table stores paths to banner/ images
• products table stores paths to product/ images
• categories table stores paths to category/ images
• shops table stores paths to shop/ images
```

---

## Sync Process Timeline

```
LOCAL EXPORT (5 minutes)
═════════════════════════════════════════════════════════════

Time  Action                          Size
──────────────────────────────────────────────────────────
T+0s  mysqldump business_settings   → 500KB
      + banners + brands +
      categories
T+1s  tar -czf storage.tar.gz       → 100-300MB (compressed)
T+30s Files ready for upload

UPLOAD (Variable, depends on connection)
═════════════════════════════════════════════════════════════

Time      Transfer Speed              Duration
────────────────────────────────────────────────────────
          1 Mbps (slow)              ~30 minutes
          10 Mbps (medium)           ~3 minutes
          100 Mbps (fast)            ~20 seconds

IMPORT ON LIVE (5 minutes)
═════════════════════════════════════════════════════════════

Time  Action                          Status
─────────────────────────────────────────────────────────
T+0s  Extract tar file                Extracting...
T+2s  Folders in place               ✓ Done
T+3s  Import SQL                      Importing...
T+4s  Fix permissions               ✓ Done
T+4s  Clear cache                    ✓ Done
T+5s  SYNC COMPLETE                  ✓ Ready

TOTAL TIME: ~40 minutes (including upload)
            OR ~10 minutes with fast connection
```

---

## What Gets Synced vs Not Synced

```
COPY FROM LOCAL TO LIVE:
✓ business_settings table      → All configuration
✓ banners table                → All banner data  
✓ brands table                 → All brand data
✓ categories table             → Category names
✓ public/storage/*             → All uploaded images
✓ shop_settings table          → Per-shop configs

DOES NOT COPY (stays on live):
✗ customer data                (keep live customers)
✗ order data                   (keep live orders)
✗ payment data                 (keep live payments)
✗ user accounts                (keep live users)
✗ vendor accounts              (keep live vendors)
✗ cart data                    (auto-generated)
✗ session data                 (auto-generated)

REASON: You only want settings/content, not user data
```

---

## Success Indicators

```
AFTER SYNC COMPLETES:
═════════════════════════════════════════════════════════════

✓ Database Check:
  mysql> SELECT COUNT(*) FROM business_settings;
  Result: > 10 (not 0 or 1)

✓ File Check:
  $ ls -la public/storage/
  Result: Shows company/, banner/, product/, etc.

✓ Visual Check:
  Browser → https://yourdomain.com
  See:
  ✓ Company logo in header
  ✓ Company name in title
  ✓ Banners on homepage
  ✓ Product images load
  ✓ Correct colors applied
  ✓ Footer logo visible

✓ Log Check:
  $ tail storage/logs/laravel.log
  Result: Normal requests, no errors
  (no "Undefined variable" errors)

✓ Configuration Check:
  php artisan tinker
  > DB::table('business_settings')->count()
  Result: > 0
```

---

## Quick Command Reference

```bash
# STEP 1: EXPORT LOCAL
mysqldump -u root -p multivendor business_settings banners brands categories > config.sql
tar -czf storage.tar.gz public/storage/

# STEP 2: TRANSFER
scp config.sql storage.tar.gz username@yourdomain.com:/tmp/

# STEP 3: IMPORT ON LIVE
ssh username@yourdomain.com
cd /home/username/public_html
mysql -u live_user -p'password' live_db < /tmp/config.sql
tar -xzf /tmp/storage.tar.gz
chmod -R 755 public/storage/
php artisan cache:clear
php artisan config:cache

# STEP 4: VERIFY
curl https://yourdomain.com | grep -i "title"  # See page title
tail -20 storage/logs/laravel.log               # Check for errors
```

---

## Troubleshooting Decision Tree

```
SYNC COMPLETE BUT SOMETHING WRONG?
═════════════════════════════════════════════════════════════

Question 1: Can you see the website at all?
├─ NO → Check if server is running
│       └─ Is PHP running? Check error logs
└─ YES → Go to Question 2

Question 2: Is the logo showing?
├─ NO → Check files: ls public/storage/company/
│       └─ Files missing? Re-extract tar.gz
│       └─ Files there? Fix permissions: chmod -R 755
└─ YES → Go to Question 3

Question 3: Is company name showing in title?
├─ NO → Check database: mysql> SELECT * FROM business_settings LIMIT 5;
│       └─ Empty? Re-import SQL
│       └─ Has data? Clear cache: php artisan cache:clear
└─ YES → Go to Question 4

Question 4: Are product images showing?
├─ NO → Check product images: ls public/storage/product/thumbnail/
│       └─ Missing? Need to copy product images separately
└─ YES → All good!

Question 5: Any errors in browser console (F12)?
├─ 404 errors on images → Path issue, check storage folder
├─ Mixed content warning → Use HTTPS only
└─ No errors → Success!
```

---

## Size & Time Estimates by Scenario

```
SCENARIO 1: Small Store (Few products, new setup)
File Size: ~50MB
DB Size: ~2MB
Time: 5 minutes

SCENARIO 2: Medium Store (100-500 products, some history)
File Size: ~300MB
DB Size: ~20MB
Time: 15 minutes

SCENARIO 3: Large Store (1000+ products, lots of orders)
File Size: ~1GB+
DB Size: ~100MB+
Time: 45 minutes +
(Recommendation: Only copy settings, not all product data)
```

---

**Your system now has full configuration sync capability!**
**Choose SYNC_QUICK_REFERENCE.md for simple steps**
**Or LOCAL_TO_LIVE_SYNC_GUIDE.md for detailed explanations**

